package localhost_8080.wsif.TimeServer;

import java.util.*;
import javax.wsdl.*;
import com.ibm.wsdl.xml.*;
import com.ibm.wsif.*;
import com.ibm.wsif.stub.*;

/**
 * This shows an example of using the JNDI registry at runtime
 * to locate a port factory. If the JNDI lookup fails, then the
 * WSDL document is used to initialize a dynamic port factory.
 * The port factory is then consulted for a suitable port for
 * this stub to use.
 */
public class TimeServicePortTypeStub extends WSIFStub
  implements TimeServicePortType
{
  private final String DOCUMENT_BASE =
    "http://localhost:8080/wsif/TimeServer.wsdl";
  private final String PORT_TYPE_NS =
    "http://localhost:8080/wsif/TimeServer-interface";
  private final String PORT_TYPE_NAME = "TimeServicePortType";

  /**
   * Create a new stub using a port factory obtained via JNDI. If that
   * doesn't work, use the WSDL document provided at compile-time to
   * initialize a dynamic port factory. If serviceNS and serviceName
   * are not null, they will be used in selecting a service.
   */
  public TimeServicePortTypeStub(String serviceNS, String serviceName) 
    throws WSIFException
  {
    locatePortFactory(
      null,
      DOCUMENT_BASE,
      WSDL_DEFINITION_STR,
      serviceNS,
      serviceName,
      PORT_TYPE_NS,
      PORT_TYPE_NAME);
  }

  /**
   * Create a new stub using a port factory obtained via JNDI. If that
   * doesn't work, use the specified WSDL document to initialize a
   * dynamic port factory. If serviceNS and serviceName are not null,
   * they will be used in selecting a service.
   */
  public TimeServicePortTypeStub(Definition def,
    String serviceNS,
    String serviceName) throws WSIFException
  {
    locatePortFactory(
      def,
      null,
      null,
      serviceNS,
      serviceName,
      PORT_TYPE_NS,
      PORT_TYPE_NAME);
  }

  public long synchronizeTime() throws WSIFException
  {
    WSIFMessage input = wp.createInputMessage();


    WSIFMessage output = wp.createOutputMessage();

    wp.executeRequestResponseOperation("synchronizeTime", 
      input, output, null);

    WSIFPart part = output.getPart("return");

    return ((Long)part.getJavaValue()).longValue();
  }

  public String getTimeAtCity(String zoneName) throws WSIFException
  {
    WSIFMessage input = wp.createInputMessage();

    input.setPart("zoneName", new WSIFJavaPart(String.class, zoneName));

    WSIFMessage output = wp.createOutputMessage();

    wp.executeRequestResponseOperation("getTimeAtCity", 
      input, output, null);

    WSIFPart part = output.getPart("return");

    return (String)part.getJavaValue();
  }

  private static final String WSDL_DEFINITION_STR =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + "\r\n" +
    "<definitions name=\"TimeService\" targetNamespace=\"http://localhost:8080/wsif/TimeServer\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\" xmlns:tns=\"http://localhost:8080/wsif/TimeServer\" xmlns:java=\"http://schemas.xmlsoap.org/wsdl/java/\" xmlns:tns-inter=\"http://localhost:8080/wsif/TimeServer-interface\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns=\"http://schemas.xmlsoap.org/wsdl/\">" + "\r\n" +
    "  <import namespace=\"http://localhost:8080/wsif/TimeServer-interface\" location=\"http://localhost:8080/wsif/TimeServer-interface.wsdl\"/>" + "\r\n" +
    "  <binding name=\"TimeServiceSOAPBinding\" type=\"tns-inter:TimeServicePortType\">" + "\r\n" +
    "    <soap:binding style=\"rpc\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + "\r\n" +
    "    <operation name=\"synchronizeTime\">" + "\r\n" +
    "      <soap:operation soapAction=\"\"/>" + "\r\n" +
    "      <input>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </input>" + "\r\n" +
    "      <output>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </output>" + "\r\n" +
    "    </operation>" + "\r\n" +
    "    <operation name=\"getTimeAtCity\">" + "\r\n" +
    "      <soap:operation soapAction=\"\"/>" + "\r\n" +
    "      <input>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </input>" + "\r\n" +
    "      <output>" + "\r\n" +
    "        <soap:body use=\"encoded\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" namespace=\"urn:TimeServer\"/>" + "\r\n" +
    "      </output>" + "\r\n" +
    "    </operation>" + "\r\n" +
    "  </binding>" + "\r\n" +
    "  <service name=\"TimeService\">" + "\r\n" +
    "<documentation>" + "\r\n" +
    "		   Central time server." + "\r\n" +
    "		   Can provide current GMT time in milliseconds since the epoch, or" + "\r\n" +
    "		   the current time from the server's perspective for a particular" + "\r\n" +
    "		   time zone. " + "\r\n" +
    "		</documentation>" + "\r\n" +
    "    <port name=\"TimeServiceSOAPPort\" binding=\"tns:TimeServiceSOAPBinding\">" + "\r\n" +
    "      <soap:address location=\"http://localhost:8080/soap/servlet/rpcrouter\"/>" + "\r\n" +
    "    </port>" + "\r\n" +
    "  </service>" + "\r\n" +
    "</definitions>";
}
